/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.ReflectionUtils;

public final class WinRegistry {
    public static final long HKEY_CURRENT_USER = 0x80000001L;
    public static final long HKEY_LOCAL_MACHINE = 0x80000002L;
    private static final long REG_SUCCESS = 0L;
    private static final int KEY_READ = 131097;
    private static final Preferences USER_ROOT = Preferences.userRoot();
    private static final Preferences SYSTEM_ROOT = Preferences.systemRoot();
    private static final Class<? extends Preferences> USER_CLASS = USER_ROOT.getClass();
    private static final String HKEY_EQ = "hkey=";
    private static final Method REG_OPEN_KEY = WinRegistry.getDeclaredMethod("WindowsRegOpenKey", Long.TYPE, byte[].class, Integer.TYPE);
    private static final Method REG_CLOSE_KEY = WinRegistry.getDeclaredMethod("WindowsRegCloseKey", Long.TYPE);
    private static final Method REG_QUERY_VALUE_EX = WinRegistry.getDeclaredMethod("WindowsRegQueryValueEx", Long.TYPE, byte[].class);
    private static final Method REG_ENUM_VALUE = WinRegistry.getDeclaredMethod("WindowsRegEnumValue", Long.TYPE, Integer.TYPE, Integer.TYPE);
    private static final Method REG_QUERY_INFO_KEY = WinRegistry.getDeclaredMethod("WindowsRegQueryInfoKey1", Long.TYPE);
    private static final Method REG_ENUM_KEY_EX = WinRegistry.getDeclaredMethod("WindowsRegEnumKeyEx", Long.TYPE, Integer.TYPE, Integer.TYPE);

    private static Method getDeclaredMethod(String name, Class<?> ... parameterTypes) {
        try {
            return USER_CLASS.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to find WindowsReg method", e);
            return null;
        }
        catch (RuntimeException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to get WindowsReg method", e);
            return null;
        }
    }

    private WinRegistry() {
    }

    public static String readString(long hkey, String key, String valueName) throws IllegalAccessException, InvocationTargetException {
        if (hkey == 0x80000002L) {
            return WinRegistry.readString(SYSTEM_ROOT, hkey, key, valueName);
        }
        if (hkey == 0x80000001L) {
            return WinRegistry.readString(USER_ROOT, hkey, key, valueName);
        }
        throw new IllegalArgumentException(HKEY_EQ + hkey);
    }

    public static Map<String, String> readStringValues(long hkey, String key) throws IllegalAccessException, InvocationTargetException {
        if (hkey == 0x80000002L) {
            return WinRegistry.readStringValues(SYSTEM_ROOT, hkey, key);
        }
        if (hkey == 0x80000001L) {
            return WinRegistry.readStringValues(USER_ROOT, hkey, key);
        }
        throw new IllegalArgumentException(HKEY_EQ + hkey);
    }

    public static List<String> readStringSubKeys(long hkey, String key) throws IllegalAccessException, InvocationTargetException {
        if (hkey == 0x80000002L) {
            return WinRegistry.readStringSubKeys(SYSTEM_ROOT, hkey, key);
        }
        if (hkey == 0x80000001L) {
            return WinRegistry.readStringSubKeys(USER_ROOT, hkey, key);
        }
        throw new IllegalArgumentException(HKEY_EQ + hkey);
    }

    private static long getNumber(Object array, int index) {
        if (array instanceof long[]) {
            return ((long[])array)[index];
        }
        throw new IllegalArgumentException();
    }

    private static String readString(Preferences root, long hkey, String key, String value) throws IllegalAccessException, InvocationTargetException {
        if (REG_OPEN_KEY == null || REG_QUERY_VALUE_EX == null || REG_CLOSE_KEY == null) {
            return null;
        }
        Object handles = REG_OPEN_KEY.invoke((Object)root, hkey, WinRegistry.toCstr(key), 131097);
        if (WinRegistry.getNumber(handles, 1) != 0L) {
            return null;
        }
        byte[] valb = (byte[])REG_QUERY_VALUE_EX.invoke((Object)root, WinRegistry.getNumber(handles, 0), WinRegistry.toCstr(value));
        REG_CLOSE_KEY.invoke((Object)root, WinRegistry.getNumber(handles, 0));
        return valb != null ? new String(valb, StandardCharsets.UTF_8).trim() : null;
    }

    private static Map<String, String> readStringValues(Preferences root, long hkey, String key) throws IllegalAccessException, InvocationTargetException {
        if (REG_OPEN_KEY == null || REG_QUERY_INFO_KEY == null || REG_ENUM_VALUE == null || REG_CLOSE_KEY == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> results = new HashMap<String, String>();
        Object handles = REG_OPEN_KEY.invoke((Object)root, hkey, WinRegistry.toCstr(key), 131097);
        if (WinRegistry.getNumber(handles, 1) != 0L) {
            return Collections.emptyMap();
        }
        Object info = REG_QUERY_INFO_KEY.invoke((Object)root, WinRegistry.getNumber(handles, 0));
        int count = Math.toIntExact(WinRegistry.getNumber(info, 0));
        int maxlen = Math.toIntExact(WinRegistry.getNumber(info, 3));
        for (int index = 0; index < count; ++index) {
            byte[] name = (byte[])REG_ENUM_VALUE.invoke((Object)root, WinRegistry.getNumber(handles, 0), index, maxlen + 1);
            String value = WinRegistry.readString(hkey, key, new String(name, StandardCharsets.UTF_8));
            results.put(new String(name, StandardCharsets.UTF_8).trim(), value);
        }
        REG_CLOSE_KEY.invoke((Object)root, WinRegistry.getNumber(handles, 0));
        return Collections.unmodifiableMap(results);
    }

    private static List<String> readStringSubKeys(Preferences root, long hkey, String key) throws IllegalAccessException, InvocationTargetException {
        if (REG_OPEN_KEY == null || REG_QUERY_INFO_KEY == null || REG_ENUM_KEY_EX == null || REG_CLOSE_KEY == null) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>();
        Object handles = REG_OPEN_KEY.invoke((Object)root, hkey, WinRegistry.toCstr(key), 131097);
        if (WinRegistry.getNumber(handles, 1) != 0L) {
            return Collections.emptyList();
        }
        Object info = REG_QUERY_INFO_KEY.invoke((Object)root, WinRegistry.getNumber(handles, 0));
        int count = Math.toIntExact(WinRegistry.getNumber(info, 0));
        int maxlen = Math.toIntExact(WinRegistry.getNumber(info, 3));
        for (int index = 0; index < count; ++index) {
            byte[] name = (byte[])REG_ENUM_KEY_EX.invoke((Object)root, WinRegistry.getNumber(handles, 0), index, maxlen + 1);
            results.add(new String(name, StandardCharsets.UTF_8).trim());
        }
        REG_CLOSE_KEY.invoke((Object)root, WinRegistry.getNumber(handles, 0));
        return Collections.unmodifiableList(results);
    }

    private static byte[] toCstr(String str) {
        byte[] array = str.getBytes(StandardCharsets.UTF_8);
        byte[] biggerCopy = Arrays.copyOf(array, array.length + 1);
        biggerCopy[array.length] = 0;
        return biggerCopy;
    }

    static {
        ReflectionUtils.setObjectsAccessible(REG_OPEN_KEY, REG_CLOSE_KEY, REG_QUERY_VALUE_EX, REG_ENUM_VALUE, REG_QUERY_INFO_KEY, REG_ENUM_KEY_EX);
    }
}

