/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.console;

import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.terminal.Terminals;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.nativeintegration.console.NativePlatformConsoleMetaData;
import org.gradle.internal.os.OperatingSystem;

public class NativePlatformConsoleDetector
implements ConsoleDetector {
    private final Terminals terminals;

    public NativePlatformConsoleDetector(Terminals terminals) {
        this.terminals = terminals;
    }

    @Override
    public ConsoleMetaData getConsole() {
        String term = System.getenv("TERM");
        if (term != null && term.equals("dumb") || OperatingSystem.current().isUnix() && term == null) {
            return null;
        }
        boolean stdout = this.terminals.isTerminal(Terminals.Output.Stdout);
        boolean stderr = this.terminals.isTerminal(Terminals.Output.Stderr);
        try {
            if (stdout) {
                return new NativePlatformConsoleMetaData(stdout, stderr, this.terminals.getTerminal(Terminals.Output.Stdout));
            }
            if (stderr) {
                return new NativePlatformConsoleMetaData(stdout, stderr, this.terminals.getTerminal(Terminals.Output.Stderr));
            }
            return null;
        }
        catch (NativeException ex) {
            return null;
        }
    }

    @Override
    public boolean isConsoleInput() {
        return this.terminals.isTerminalInput();
    }
}

