/*
 * Decompiled with CFR 0.152.
 */
package XMLConsumer;

import XMLConsumer.IEntry;
import XMLConsumer.IdxData;
import XMLConsumer.SecondaryDialog;
import XMLConsumer.Topic;
import hhapplet.BsscFontFixPatch;
import hhapplet.IActionSink;
import hhapplet.URLFileHandler;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class IdxEntry
implements IEntry {
    public static final int IDX_NODE = 1;
    public static final int IDX_KEY = 2;
    public static final int IDX_SUBKEY = 3;
    private int m_nNext;
    private int m_nPrev;
    private String m_name;
    private Vector m_topics;
    private int m_nType;
    private int m_nLevel;
    private boolean m_bSelect;
    private boolean m_bHighLight;
    private IdxData m_IdxData;
    private String m_target;
    private static SecondaryDialog m_dialog = null;
    private static Color GREEN = new Color(0, 127, 0);
    private static final int IDX_INDENT = 10;
    private static Color m_activeColor = Color.gray;
    private static Color m_hoverColor = GREEN;
    private static int m_indent = 10;
    private static Font m_normalFont = new Font(BsscFontFixPatch.GetFontName(), 0, BsscFontFixPatch.GetFontSize());
    private static Font m_hoverFont = new Font(BsscFontFixPatch.GetFontName(), 0, BsscFontFixPatch.GetFontSize());
    private static Color m_normalColor = Color.black;
    private static boolean m_normalUnderline = false;
    private static boolean m_hoverUnderline = true;

    public static SecondaryDialog getDialog(IActionSink iActionSink, URL uRL, String string, Vector vector) {
        if (m_dialog != null) {
            m_dialog.closeDialog();
            m_dialog = null;
        }
        m_dialog = new SecondaryDialog(iActionSink, uRL, string, vector);
        return m_dialog;
    }

    public int getPrevSpan() {
        return this.m_nPrev;
    }

    public void setTarget(String string) {
        this.m_target = string;
    }

    public static void setHoverUnderline(boolean bl) {
        m_hoverUnderline = bl;
    }

    public boolean isMainEntry() {
        return this.m_nType == 2;
    }

    public static void setNormalColor(Color color) {
        m_normalColor = color;
    }

    public static void setHoverFont(Font font) {
        if (font.getSize() != m_normalFont.getSize()) {
            m_hoverFont = new Font(font.getFamily(), font.getStyle(), m_normalFont.getSize());
            return;
        }
        m_hoverFont = font;
    }

    public IdxEntry(String string, int n, int n2, int n3, IdxData idxData) {
        this.m_name = string;
        this.m_nPrev = n;
        this.m_nNext = 0;
        this.m_nType = n2;
        this.m_nLevel = n3;
        this.m_bHighLight = false;
        this.m_bSelect = false;
        this.m_IdxData = idxData;
        this.m_target = null;
    }

    public Enumeration getTopics() {
        if (this.m_topics != null) {
            return this.m_topics.elements();
        }
        return null;
    }

    public void select(boolean bl) {
        this.m_bSelect = bl;
    }

    public void addTopic(Topic topic) {
        if (this.m_topics == null) {
            this.m_topics = new Vector();
        }
        this.m_topics.addElement(topic);
    }

    public static void setNormalFont(Font font) {
        m_normalFont = font;
    }

    public static void setNormalUnderline(boolean bl) {
        m_normalUnderline = bl;
    }

    public static void setActiveColor(Color color) {
        m_activeColor = color;
    }

    public String getName() {
        return this.m_name;
    }

    public void highLight(boolean bl) {
        this.m_bHighLight = bl;
    }

    public void action(IActionSink iActionSink) {
        if (this.m_topics != null) {
            if (this.m_topics.size() == 1) {
                Topic topic = (Topic)this.m_topics.elementAt(0);
                try {
                    URL uRL = URLFileHandler.makeURL(this.m_IdxData.getProjURL(), topic.getURL(), null);
                    String string = uRL.toString();
                    if (string.indexOf("file:/\\\\") == 0) {
                        string = "file://" + string.substring(8);
                        uRL = new URL(string);
                    }
                    Vector<String> vector = new Vector<String>();
                    vector.addElement(uRL.toString());
                    vector.addElement(this.m_target);
                    iActionSink.accept(vector);
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return;
                }
            }
            SecondaryDialog secondaryDialog = IdxEntry.getDialog(iActionSink, this.m_IdxData.getProjURL(), this.m_target, this.m_topics);
            secondaryDialog.showTopic();
            secondaryDialog.getList().requestFocus();
        }
    }

    public int getType() {
        return this.m_nType;
    }

    public int getNextSpan() {
        return this.m_nNext;
    }

    public void display(Graphics graphics, int n, int n2, Color color, Image image) {
        int n3;
        FontMetrics fontMetrics = graphics.getFontMetrics(m_normalFont);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(m_hoverFont);
        int n4 = fontMetrics.stringWidth(this.m_name + " ");
        n4 = n4 > (n3 = fontMetrics2.stringWidth(this.m_name + " ")) ? n4 : n3;
        int n5 = fontMetrics.getAscent();
        int n6 = fontMetrics.getLeading();
        int n7 = fontMetrics2.getAscent();
        int n8 = fontMetrics2.getLeading();
        switch (this.m_nType) {
            case 1: {
                Color color2 = graphics.getColor();
                if (this.m_bSelect) {
                    graphics.setColor(m_activeColor);
                    graphics.fill3DRect(0, n * n2, n4, n2, true);
                } else if (image != null) {
                    graphics.drawImage(image, 0, n * n2, n4, n * n2 + n2, 0, n * n2, n4, n * n2 + n2, null);
                } else {
                    graphics.setColor(color);
                    graphics.fillRect(0, n * n2, n4, n2);
                }
                graphics.setColor(color2);
                Font font = graphics.getFont();
                Font font2 = new Font(font.getName(), font.getStyle() | 1, font.getSize());
                graphics.setFont(font2);
                graphics.drawString(this.m_name, 0, n * n2 + n5 + n6);
                graphics.setFont(font);
                return;
            }
            case 2: 
            case 3: {
                Color color3 = graphics.getColor();
                if (this.m_bSelect) {
                    graphics.setColor(m_activeColor);
                    graphics.fill3DRect(m_indent * this.m_nLevel, n * n2, n4, n2, true);
                } else if (image != null) {
                    graphics.drawImage(image, m_indent * this.m_nLevel, n * n2, m_indent * this.m_nLevel + n4, n * n2 + n2, m_indent * this.m_nLevel, n * n2, m_indent * this.m_nLevel + n4, n * n2 + n2, null);
                } else {
                    graphics.setColor(color);
                    graphics.fillRect(m_indent * this.m_nLevel, n * n2, n4, n2);
                }
                graphics.setColor(color3);
                Font font = graphics.getFont();
                if (this.m_bHighLight) {
                    graphics.setColor(m_hoverColor);
                    graphics.setFont(m_hoverFont);
                    graphics.drawString(this.m_name, m_indent * this.m_nLevel, n * n2 + n7 + n8);
                    if (m_hoverUnderline) {
                        graphics.drawLine(m_indent * this.m_nLevel, (n + 1) * n2 - 1, m_indent * this.m_nLevel + n4 - 1, (n + 1) * n2 - 1);
                    }
                    graphics.setFont(font);
                    graphics.setColor(color3);
                    return;
                }
                graphics.setColor(m_normalColor);
                graphics.setFont(m_normalFont);
                graphics.drawString(this.m_name, m_indent * this.m_nLevel, n * n2 + n5 + n6);
                if (m_normalUnderline) {
                    graphics.drawLine(m_indent * this.m_nLevel, (n + 1) * n2 - 1, m_indent * this.m_nLevel + n4 - 1, (n + 1) * n2 - 1);
                }
                graphics.setFont(font);
                graphics.setColor(color3);
            }
        }
    }

    public static void setIndent(int n) {
        m_indent = n;
    }

    public void setNextSpan(int n) {
        this.m_nNext = n;
    }

    public int getWidth(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(m_normalFont);
        int n = fontMetrics.stringWidth(this.m_name + " ");
        return m_indent * this.m_nLevel + n + 1;
    }

    public static void setHoverColor(Color color) {
        m_hoverColor = color;
    }
}

