<?xml version="1.0" encoding="utf-8"?>

<!--
    $Id: siteadmin.navbar.xsl,v 1.9.2.2.2.1 2007/02/06 04:38:18 skathalkar Exp $
    $Log: siteadmin.navbar.xsl,v $
    Revision 1.9.2.2.2.1  2007/02/06 04:38:18  skathalkar
    merging epl-10-2-0-branch into epl-11-0-0-branch

    Revision 1.9.2.4.2.1  2007/01/08 09:01:51  skathalkar
    PR# 1084887: 10.1.0 :: Generic :: Lang Pack :: Redirect Online help link (German & Spanish) on ISP admin to English.

    Revision 1.9.2.4  2006/11/23 10:51:19  skathalkar
    Fix for PR#1084425: Change required for FC6.

    Revision 1.9.2.3  2006/11/23 10:34:26  msahni
    Fix for PR#1084425: Siteadmin navbar shows items (ones without a hyperlinks) which have no subitems under them.

    Revision 1.9.2.2  2006/07/27 11:12:56  msahani
    changes made for showing dns option on navbar when zone management is enabled

    Revision 1.9.2.1  2006/07/27 07:03:42  msahani
    changes made to support dns at SA level.

    Revision 1.9  2006/04/20 12:31:26  rishabh
    fix for PR#1080951

    Revision 1.8  2006/04/12 13:08:31  mansoor
    XSL stylesheets need to stringify the XML nodes before calling the epl:_ localizer function

    Revision 1.7  2006/04/04 09:49:12  msahani
    enabling localization of displayed strings.

    Revision 1.6  2006/03/21 10:24:53  skodre
    fixed the reseller navbar help link

    Revision 1.5  2006/03/14 07:14:37  skodre
    removing the version string since not needed at siteadmin level

    Revision 1.4  2006/03/14 07:05:56  skodre
    added the epl version string

    Revision 1.3  2006/03/10 07:16:09  msahani
    *** empty log message ***

    Revision 1.2  2006/03/08 12:02:28  msahani
    *** empty log message ***

    Revision 1.1  2006/02/07 16:15:24  arvindd
    Changing names of XSL to be consistent with cookie names and URLs

    Revision 1.5  2006/02/07 13:38:51  msahani
    Removed all occurance of epleval and optimized the xsls.

-->

<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:tgt="http://www.w3.org/1999/xhtml"
    xmlns:epl="http://www.ensim.com/epl50"
    xmlns:saxon="http://icl.com/saxon"
    xmlns:fn="http://www.w3.org/2005/02/xpath-functions"
    xmlns:math="http://exslt.org/math"
    xmlns:sets="http://exslt.org/sets"
    xmlns:str="http://exslt.org/strings"
    xmlns:dyn="http://exslt.org/dynamic"
    xmlns:func="http://exslt.org/functions"
    exclude-result-prefixes="fn math sets dyn saxon epl"
    extension-element-prefixes="dyn func"
>

<xsl:output method="xml" indent="yes" />

<!-- This is the Site Administrator's Navigation Bar XSL
     The Site Administrator's Navbar ($frontend/static/xml/site.navbar.xml) will be passed to this
-->

<func:function name="func:isItemDisplayable">
  <xsl:param name="item_node"/>
  <xsl:variable name="enabledservice" select="$item_node/service/text()" />
  <xsl:choose>
    <xsl:when test="./child::node()[name() = 'service'] and ./service/text()">
      <xsl:choose>
        <xsl:when test="./child::node()[name() = 'proenabled']">
          <xsl:variable name="ispro" select="epl:isPro()"/>
          <xsl:choose>
            <xsl:when test = "$ispro = 'True'">
              <xsl:variable name="serviceEnabledXPath" select='concat("/navbar/site/properties/",$enabledservice,"/enabled/text()")'/>
              <xsl:variable name="service" select="dyn:evaluate ($serviceEnabledXPath)"/>
              <xsl:choose>
                <xsl:when test="$service = 1"> 
                  <xsl:choose>
                    <xsl:when test="$enabledservice = 'bind'">
                      <xsl:choose>
                        <xsl:when test="/navbar/site/properties/bind/zone_mgmt/text() = 1">
                          <func:result select="true()"/>
                        </xsl:when>
                        <xsl:otherwise>
                          <func:result select="false()"/>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                      <func:result select="true()"/>
                    </xsl:otherwise>
                  </xsl:choose>                  
                </xsl:when>
                <xsl:otherwise>
                  <func:result select="false()"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
              <func:result select="false()"/>          
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="serviceEnabledXPath" select='concat("/navbar/site/properties/",$enabledservice,"/enabled/text()")'/>
          <xsl:variable name="service" select="dyn:evaluate ($serviceEnabledXPath)"/>
          <xsl:choose>
            <xsl:when test="$service = 1">
              <xsl:choose>
                <xsl:when test="$enabledservice = 'bind'">
                  <xsl:choose>
                    <xsl:when test="/navbar/site/properties/bind/zone_mgmt/text() = 1">
                      <func:result select="true()"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <func:result select="false()"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                  <func:result select="true()"/>      
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
              <func:result select="false()"/>
            </xsl:otherwise>
          </xsl:choose>     
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
      <func:result select="true()"/>
    </xsl:otherwise>
  </xsl:choose>             
</func:function>

<!-- This iterates over each item node in the current select and calls isItemDisplayable() function
for each item.
-->
<xsl:key name="displayItem" match="subitem" use="func:isItemDisplayable(.)"/>

<!-- This function checks if a section is to be displayed on the dashboard. A section has to be
displayed if there is even one item under it which is displayable.
-->
<func:function name="func:isSectionDisplayable">
 <xsl:param name="section_node"/>
 <xsl:choose>
  <xsl:when test="count(key('displayItem','true')[../display/text() = $section_node/display/text()]) = 0">
   <func:result select="false()"/>
  </xsl:when>
  <xsl:otherwise>
   <func:result select="true()"/>
  </xsl:otherwise>
 </xsl:choose>
</func:function>

<!--This function accepts one parameter 'link-text' which is the value of link node in navbar.xml file. It checks if the
'link_text' starts with string '/siteadmin'. If it does then it returns the value of 'link_text' as it is, otherwise it 
returns a dynamic link which looks like this: 'http://<sitename><link-from-xml>'. Here <sitename> is picked up from the 
dynamic xml included in navbar.xml file and the <link-from-xml> is the value of the 'link_text'. 'link_text' is expected 
to be preceeded by '/' character.-->
<func:function name="func:getLink">
 <xsl:param name="link_text"/>
 <xsl:choose>
  <xsl:when test="string(starts-with($link_text,'/'))='true'">
   <xsl:choose>
    <xsl:when test="string(starts-with($link_text,'/siteadmin'))='true'">
     <func:result select="$link_text"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:variable name='domain' select="string(/navbar/site/properties/siteinfo/domain)"/>
     <xsl:variable name='link' select="concat('http://', $domain, $link_text)"/>
     <func:result select="$link"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:when>
  <xsl:otherwise>
   <func:result select="$link_text"/>
  </xsl:otherwise> 
 </xsl:choose>
</func:function> 

<xsl:template match="/">

<html xmlns="http://www.w3.org/1999/xhtml">

 <!-- This is the left navigation bar of the Site Administrator
      Minimalistically, this would contain the following
 
      (.) A 'login history' page. Useful for stacked auto-logins
      (.) The actual menu items
      (.) Any footers
 -->

 <head>
  <meta content="text/html; charset=ISO-8859-1" http-equiv="content-type" />
  <link href="/static/css/site.global.css" type="text/css" rel="stylesheet" />
  <title><xsl:value-of select="epl:_('Site Admin Navigation')"/></title>
  <script language="javascript" src="/static/js/navbar.js">//	
  </script>
 </head>

 <body id="navbarFrm">

  <!-- Login Info Section: Renders the login history in case of auto-logins. -->
  <div class="navbar-rounded-box">
   <div><div><div><div>
    
   <!--
     The Login Info section displays who is currently logged in to the system.
     If a higher level administrator (say ISP), has autologged in to a lower level
     admin (say site), then the higher level administrator is shown first, and
     then follows the lower level administrators.

     If an ISP admin has autologged in as a site-admin, then the terminology used here is that
     "Logged in" as ISP Administrator,
     and
     "Working as" Site Administrator.
   -->

    <div class="logged-in-section-hidden">
     <div class="toggle-div" id="login_info"><xsl:value-of select="epl:_('Login Info')"/></div>
     <xsl:variable name="role_count" select="count(/navbar/logininfo/role)"/>

     <xsl:choose>
      <xsl:when test="$role_count = 1">
       <div class="logged-in-users">
        <xsl:value-of select="epl:_('Working as')"/>
        <div><xsl:value-of select="epl:_(string(/navbar/logininfo/role[last()]))"/></div>
       </div>
      </xsl:when>
      <xsl:otherwise>
       <div class="logged-in-users">
        <xsl:value-of select="epl:_('Logged in as')"/>
        <xsl:for-each select="/navbar/logininfo/role[position() != $role_count]">
         <div><xsl:value-of select="epl:_(string(.))"/></div>
        </xsl:for-each>
       </div>
       <div class="logged-in-users"><xsl:value-of select="epl:_('Working as')"/>
        <div><xsl:value-of select="epl:_(string(/navbar/logininfo/role[last()]))"/></div>
       </div>
      </xsl:otherwise>
     </xsl:choose>   
     <div class="logout">
      <input type="button" onClick="window.parent.location='/siteadmin/logout';" >
       <xsl:attribute name="value"><xsl:value-of select="epl:_('log out')"/></xsl:attribute>
      </input> 
     </div> 
    </div>
    
   </div></div></div></div>
  </div> 
      

  <!-- System Menu Section: Renders the actual items on the navbar --> 
  <div class="navbar-rounded-box">
   <div><div><div><div>
    <div class="navbar-menu-title"><xsl:value-of select="epl:_('Menu')"/></div>
    <div class="isp-navbar-section"  id="isp-navbar-section">  
     <xsl:apply-templates />
    </div>
   </div></div></div></div>
  </div>
  <br/> 

 </body>
</html>

</xsl:template>


<xsl:template match="/navbar/item">

 <!-- If an item node has subitem node(s) and link node then it is rendered as a clickable item along with its 
      subitem node(s) being displayed below it.
      If an item node has subitem node(s) but no link node then it is displayed as text which is not clickable. 
      It's subitem node(s) is displayed below it.
      If an item node does not have any subitem node it is rendered as a clickable item on the navbar.
 -->
 <xsl:choose>
  <xsl:when test="./display/text()='help'">
   <xsl:variable name="link" select="./link/text()"/> 
   <xsl:variable name="path" select="concat('/docs/' , epl:ohlanguage() , '/site/', $link)"/>
   <p xmlns="http://www.w3.org/1999/xhtml" class="navbar-item">
    <a href="{$path}" target="_blank">
     <xsl:value-of select="epl:_(string(./display/text()))"/>
    </a>
   </p>
  </xsl:when>
 
  <xsl:otherwise>
    <xsl:choose>
      <xsl:when test="./child::node()[name() = 'subitem']">
        <xsl:choose>
          <xsl:when test="./child::node()[name() = 'link']">
            <p xmlns="http://www.w3.org/1999/xhtml" class="navbar-item">
              <xsl:variable name="link_text" select="./link/text()"/>
              <!--The following lines of code are for rendering the dynamic link for the item. First a call to getLink()
              function is made and link_text (defined above) is passed to it. Then a check is made to see if the return
              value of the function is same as link_text passed to it. If it is then target attribute of <a> tag is
              given value "main" (i.e. the link should open in the 'main' frame of the page. Otherwise the target
              attribute of <a> tag is given value '_blank' (i.e. the link should open in a new page)-->
              <xsl:variable name="link" select="func:getLink($link_text)"/>
              <xsl:choose>
               <xsl:when test="$link_text=$link">
                <a href="{$link}" target="main"><xsl:value-of select="epl:_(string(./display/text()))"/></a>
               </xsl:when>
               <xsl:otherwise>
                <a href="{$link}" target="_blank"><xsl:value-of select="epl:_(string(./display/text()))"/></a>
               </xsl:otherwise>
              </xsl:choose> 
              <!--Code ends here-->
            </p>
          </xsl:when>
          <xsl:otherwise> 
            <xsl:if test="func:isSectionDisplayable(.) = 'true'">
              <p xmlns="http://www.w3.org/1999/xhtml" class="navbar-item">
                <span><xsl:value-of select="epl:_(string(./display/text()))"/></span>
              </p>
            </xsl:if>
          </xsl:otherwise>
        </xsl:choose>  
        <xsl:for-each select="./subitem">
          <xsl:if test="func:isItemDisplayable(.) = 'true'">
            <p xmlns="http://www.w3.org/1999/xhtml" class="navbar-item-sub1">
              <xsl:variable name="link_text" select="./link/text()"/>
              <!--The following lines of code are for rendering the dynamic link for the item. First a call to getLink()
              function is made and link_text (defined above) is passed to it. Then a check is made to see if the return
              value of the function is same as link_text passed to it. If it is then target attribute of <a> tag is
              given value "main" (i.e. the link should open in the 'main' frame of the page. Otherwise the target
              attribute of <a> tag is given value '_blank' (i.e. the link should open in a new page)-->
              <xsl:variable name="link" select="func:getLink($link_text)"/>
              <xsl:choose>
               <xsl:when test="$link_text=$link">
                <a href="{$link}" target="main"><xsl:value-of select="epl:_(string(./display/text()))"/></a>
               </xsl:when>
               <xsl:otherwise>
                <a href="{$link}" target="_blank"><xsl:value-of select="epl:_(string(./display/text()))"/></a>
               </xsl:otherwise>
              </xsl:choose>  
              <!--Code ends here-->  
            </p>
          </xsl:if>  
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="current_item" select="."/>
        <xsl:if test="func:isItemDisplayable(.) = 'true'">
          <p xmlns="http://www.w3.org/1999/xhtml" class="navbar-item">
            <xsl:variable name="link_text" select="./link/text()"/>
            <!--The following lines of code are for rendering the dynamic link for the item. First a call to getLink()
            function is made and link_text (defined above) is passed to it. Then a check is made to see if the return
            value of the function is same as link_text passed to it. If it is then target attribute of <a> tag is
            given value "main" (i.e. the link should open in the 'main' frame of the page. Otherwise the target
            attribute of <a> tag is given value '_blank' (i.e. the link should open in a new page)--> 
            <xsl:variable name="link" select="func:getLink($link_text)"/>
            <xsl:choose>
             <xsl:when test="$link_text=$link">
              <a href="{$link}" target="main"><xsl:value-of select="epl:_(string(./display/text()))"/></a>
             </xsl:when>
             <xsl:otherwise>
              <a href="{$link}" target="_blank"><xsl:value-of select="epl:_(string(./display/text()))"/></a>
             </xsl:otherwise>
            </xsl:choose>
            <!--Code ends here-->  
          </p>
        </xsl:if>    
      </xsl:otherwise>
    </xsl:choose>
  </xsl:otherwise>            
 </xsl:choose>
</xsl:template>

<xsl:template match="text()|@*"/>

</xsl:stylesheet>


